package ga.view.examples.simple;

import ga.view.interfaces.IPhenotypeGenerator;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState.BlendMode;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue.Bucket;
import com.jme3.renderer.queue.RenderQueue.ShadowMode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Sphere;
import com.jme3.scene.shape.Torus;

/**
 * Phenotype generator for the simple object example.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class SimpleObjectPhenotypeGenerator implements
    IPhenotypeGenerator<SimpleObjectIndividual, Geometry> {
  private AssetManager assetManager;

  /**
   * Instantiates a new simple object phenotype generator.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public SimpleObjectPhenotypeGenerator() {
    super();

  }

  @Override
  public void setAssetManager(final AssetManager assetManager) {
    this.assetManager = assetManager;
  }

  @Override
  public Geometry createPhenotype(final SimpleObjectIndividual individual) {
    final float r = (Float) individual.getGenotype().get(0);
    final float g = (Float) individual.getGenotype().get(1);
    final float b = (Float) individual.getGenotype().get(2);
    final int type = (Integer) individual.getGenotype().get(3);

    final Material mat = new Material(assetManager,
        "Common/MatDefs/Light/Lighting.j3md");
    mat.setFloat("Shininess", 1.5f);
    mat.setBoolean("UseMaterialColors", true);
    mat.setBoolean("UseAlpha", true);
    // teapotMat.setBoolean("UseVertexColor", true);
    mat.setColor("Ambient", ColorRGBA.White.mult(0.1f));
    mat.setColor("Diffuse", new ColorRGBA(r, g, b, 1f));
    mat.setColor("Specular", ColorRGBA.Gray);

    // mat.setBoolean("VTangent", true);
    // mat.setBoolean("Minnaert", true);
    // mat.setBoolean("VertexLighting", false);
    // mat.setBoolean("WardIso", true);
    // mat.setBoolean("LowQuality", true);
    mat.setBoolean("HighQuality", true);

    // mat.setTexture("ColorRamp",
    // assetManager.loadTexture("Textures/ColorRamp/cloudy.png"));

    mat.setReceivesShadows(true);

    mat.getAdditionalRenderState().setBlendMode(BlendMode.Alpha);

    Mesh m;

    switch (type) {
    case 0:
      m = new Box(Vector3f.ZERO, 1, 1, 1);
      break;
    case 1:
      m = new Sphere(20, 20, 1f);
      break;
    case 2:
      m = new Cylinder(20, 20, 1f, 2f, true);
      break;
    case 3:
      m = new Torus(20, 20, .3f, .7f);
      break;
    default:
      m = null;
      break;
    }

    final Geometry geo = new Geometry("Object", m);
    geo.setMaterial(mat);
    geo.setShadowMode(ShadowMode.CastAndReceive);
    geo.setQueueBucket(Bucket.Transparent);
    geo.setLocalTranslation(new Vector3f(0, 1, 0));

    return geo;
  }
}
